IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'UFD_EST_PROD_COMIS_HISTORICO') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
    DROP FUNCTION UFD_EST_PROD_COMIS_HISTORICO
GO 

CREATE FUNCTION [UFD_EST_PROD_COMIS_HISTORICO](@CD_EMP    INT
											, @CD_FILIAL INT
											, @CD_PROD   INT
											, @CD_FUN    INT
											, @FLAG_PRE_VENCIDOS INT = 0
											, @DT_VD DATETIME
											)
          

/*   
 FUNO:  UFD_EST_PROD_COMIS
 OBJETIVO: RETORNAR COMISSAO
 AUTOR:  FERNANDO JUNIO CUNHA E SOUSA  
 CRIACAO: 05/2012  
   
FUNÇÃO PARA RETORNAR MELHOR VALOR DAS TBLS DE COMISSAO PERC(%) E REAL(R$)
	Variáveis de entrada
		@CD_FILIAL	= COD DA FILIAL
		@CD_PROD		= COD DO PRODUTO
		@CD_FUN		= COD DO VENDEDOR
	
	Variáveis de saída na tabela :@RS_TAB_COMIS
		 CD_PROD			= COD PRODUTO
		 CD_TBL_COMIS_PERC	= cod da tabela que contem a maior COMISSAO PERC
		 TP_NIVEL_PERC		= RETORNA EM QUAL NIVEL FOI DADO A COMISSAO PERCENTUAL
		 PERC_COMIS		= VALOR PERCENTUAL DA COMISSAO
		 CD_TBL_COMIS_VLR	= COD DA TABELA QUE CONTEM O MAIOR VALOR DE COMISSAO(R$)
		 TP_NIVEL_VLR		= RETORNA EM QUAL NIVEL FOI DADO A COMISSAO EM (R$)
		 VLR_COMIS		= VALOR REAL DA COMISSAO(R$)
		 DS_COMIS_VLR		= DESCRICAO DO TIPO DE COMISSAO(R$)
	
*/
 
RETURNS @RS_RET TABLE (CD_PROD            INT
							, CD_TBL_COMIS_PERC  INT
							, TP_NIVEL_PERC      INT
							, PERC_COMIS         MONEY
							, DS_COMIS_PERC      VARCHAR(100)
							, FLAG_DESC_OUTR_TBL INT
							, CD_TBL_COMIS_VLR   INT
							, TP_NIVEL_VLR       INT
							, VLR_COMIS          MONEY
							, DS_COMIS_VLR       VARCHAR(100)
							)
AS
BEGIN
-------------------------------------------------------------------------------------------------------------------------------

	DECLARE @RS_TAB_COMIS TABLE (CD_PROD            INT
								, CD_TBL_COMIS_PERC  INT
								, TP_NIVEL_PERC      INT
								, PERC_COMIS         MONEY
								, DS_COMIS_PERC      VARCHAR(50)
								, FLAG_DESC_OUTR_TBL INT
								, CD_TBL_COMIS_VLR   INT
								, TP_NIVEL_VLR       INT
								, VLR_COMIS          MONEY
								, DS_COMIS_VLR       VARCHAR(50)
								);

	DECLARE @TBL_NIVEL TABLE(TP_NIVEL INT, DS_NIVEL VARCHAR(20));

-------------------------------------------------------------------------------------------------------------------------------
	
	INSERT INTO @TBL_NIVEL
		  SELECT 1, 'PRODUTO'
	UNION SELECT 2, 'FAMILIA'
	UNION SELECT 3, 'MARCA'
	UNION SELECT 4, 'FABRICANTE'
	UNION SELECT 5, 'CATEGORIA'
	UNION SELECT 6, 'LINHA'
	UNION SELECT 7, 'FILIAL';

-------------------------------------------------------------------------------------------------------------------------------

	INSERT INTO @RS_TAB_COMIS
	SELECT
		B.CD_PROD
		, CASE WHEN TP_VALOR = 0 THEN 
				B.CD_TBL_COMIS  ELSE 0 END AS CD_TBL_COMIS_PERC
		, CASE WHEN TP_VALOR = 0 THEN  
				B.TP_NIVEL	ELSE 0  END AS TP_NIVEL_PERC
		, CASE WHEN TP_VALOR = 0 THEN  
					B.PERC_COMIS	ELSE 0  END AS PERC_COMIS  
		, '' AS DS_COMIS_PERC
		, B.FLAG_DESC_OUTR_TBL
		--Comissao por valor
		, CASE WHEN TP_VALOR = 1 THEN 
				B.CD_TBL_COMIS  ELSE 0 END AS CD_TBL_COMIS
		, CASE WHEN TP_VALOR = 1 THEN  
				B.TP_NIVEL	ELSE 0  END AS TP_NIVEL
		, CASE WHEN TP_VALOR = 1 THEN  
					B.PERC_COMIS	ELSE 0  END AS PERC_COMIS 

		, '' AS DS_COMIS_VLR
	FROM
		UFD_EST_PROD_COMIS_VALORES_HISTORICO(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FUN, 2, @FLAG_PRE_VENCIDOS, @DT_VD) B;
		 
 
-------------------------------------------------------------------------------------------------------------------------------

		INSERT INTO @RS_RET
		SELECT
			MAX(CD_PROD) AS CD_PROD
			, (CASE
					WHEN MAX(ISNULL(FLAG_DESC_OUTR_TBL, 0)) = 0 THEN MAX(CD_TBL_COMIS_PERC)
					ELSE 0
				END) AS CD_TBL_COMIS_PERC
			, (CASE
					WHEN MAX(ISNULL(FLAG_DESC_OUTR_TBL, 0)) = 0 THEN MAX(TP_NIVEL_PERC)
					ELSE 0
				END) AS TP_NIVEL_PERC
			, (CASE
					WHEN MAX(ISNULL(FLAG_DESC_OUTR_TBL, 0)) = 0 THEN MAX(PERC_COMIS)
					ELSE 0
				END) AS PERC_COMIS
			, (CASE
					WHEN MAX(ISNULL(FLAG_DESC_OUTR_TBL, 0)) = 1 THEN 'COMISSAO ANULADA(%) PELO DESC. VALOR - TAB: '+CAST(MAX(CD_TBL_COMIS_VLR) AS VARCHAR)+' NIVEL: '+
					(
						SELECT
								DS_NIVEL
						FROM
							@TBL_NIVEL N
						WHERE  N.TP_NIVEL = MAX(T.TP_NIVEL_VLR)
					)
											WHEN MAX(ISNULL(PERC_COMIS, 0)) = 0
												AND MAX(CD_TBL_COMIS_PERC) > 0 THEN 'COMISSAO ANULADA(%) PELO NIVEL - TAB: '+CAST(MAX(CD_TBL_COMIS_PERC) AS VARCHAR)+' NIVEL: '+
					(
						SELECT
								DS_NIVEL
						FROM
							@TBL_NIVEL N
						WHERE  N.TP_NIVEL = MAX(T.TP_NIVEL_PERC)
					)
					WHEN MAX(ISNULL(PERC_COMIS, 0)) = 0
						AND MAX(CD_TBL_COMIS_PERC) = 0 THEN 'SEM COMISSAO(%)'
					WHEN MAX(ISNULL(PERC_COMIS, 0)) > 0
						AND MAX(CD_TBL_COMIS_PERC) > 0 THEN CASE WHEN @FLAG_PRE_VENCIDOS = 1 THEN 'MELHOR COMISSAO P.V.(%) - TAB: ' ELSE 'MELHOR COMISSAO(%) - TAB: ' END+CAST(MAX(CD_TBL_COMIS_PERC) AS VARCHAR)+' NIVEL: '+
					(
						SELECT
								DS_NIVEL
						FROM
							@TBL_NIVEL N
						WHERE  N.TP_NIVEL = MAX(T.TP_NIVEL_PERC)
					)
					ELSE 'NAO DEFINIDO'
				END) AS DS_COMIS_PERC
			, MAX(FLAG_DESC_OUTR_TBL) AS FLAG_DESC_OUTR_TBL
			, MAX(CD_TBL_COMIS_VLR) AS CD_TBL_COMIS_VLR
			, MAX(TP_NIVEL_VLR) AS TP_NIVEL_VLR
			, MAX(VLR_COMIS) AS VLR_COMIS
			, (CASE
					WHEN MAX(ISNULL(VLR_COMIS, 0)) = 0
						AND MAX(CD_TBL_COMIS_VLR) > 0 THEN 'COMISSAO ANULADA(R$) PELO NÍVEL - TAB: '+CAST(MAX(CD_TBL_COMIS_VLR) AS VARCHAR)+' NIVEL: '+
					(
						SELECT
								DS_NIVEL
						FROM
							@TBL_NIVEL N
						WHERE  N.TP_NIVEL = MAX(T.TP_NIVEL_VLR)
					)
					WHEN MAX(ISNULL(VLR_COMIS, 0)) = 0
						AND MAX(CD_TBL_COMIS_VLR) = 0 THEN 'SEM COMISSAO(R$)'
					WHEN MAX(ISNULL(VLR_COMIS, 0)) > 0
						AND MAX(CD_TBL_COMIS_VLR) > 0 THEN CASE WHEN @FLAG_PRE_VENCIDOS = 1 THEN 'MELHOR COMISSAO P.V.(R$) - TAB: ' ELSE 'MELHOR COMISSAO(R$) - TAB: ' END+CAST(MAX(CD_TBL_COMIS_VLR) AS VARCHAR)+' NIVEL: '+
					(
						SELECT
								DS_NIVEL
						FROM
							@TBL_NIVEL N
						WHERE  N.TP_NIVEL = MAX(T.TP_NIVEL_VLR)
					)
					ELSE 'NAO DEFINIDO'
				END) AS DS_COMIS_VLR
		FROM
			@RS_TAB_COMIS T;


	RETURN;
END;

GO


